/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.levelEditor;

import BryceMath.Calculations.Colors;
import Data_Structures.Structures.BitSet;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.Room;
import Game_Engine.Engine.engine.Game_input;
import Game_Engine.Engine.engine.Game_output;
import Game_Engine.GUI.Components.Input.gui_booleanInput;
import Game_Engine.GUI.Components.large.gui_array;
import Game_Engine.GUI.Components.large.gui_list;
import Game_Engine.GUI.Components.large.gui_window;
import Game_Engine.GUI.Components.small.gui_button;
import Game_Engine.GUI.Components.small.gui_label;
import Game_Engine.SpriteFactories.ArrowImageFactory;
import Game_Engine.levelEditor.editor_components.EntitySelector;
import Game_Engine.levelEditor.editor_components.gui_level_editor;
import Game_Engine.levelEditor.editor_components.obj_button;
import Game_Engine.levelEditor.room_GameTree;
import Game_Engine.levelEditor.room_fileChooser;
import Game_Engine.levelEditor.room_level;
import Game_Engine.levelEditor.rootSerial;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintStream;
import util.FileIO;
import util.interfaces.Function;

public abstract class room_editor
extends Room {
    int game_w = this.getGameW();
    int game_h = this.getGameH();
    gui_level_editor level;
    gui_button grid_toggle;
    gui_button lights_toggle;
    gui_button save_level;
    gui_button load_level;
    gui_button run_level;
    static room_fileChooser chooser_room;
    gui_button clearRoom;
    gui_label label_mouse_x;
    gui_label label_mouse_y;
    gui_booleanInput edit_mode;
    FileMode fileMode = FileMode.save;
    boolean calling = false;
    public static gui_array<gui_booleanInput> directions;
    room_GameTree room_level_tree;
    gui_button button_level_tree;
    gui_button button_run_game;

    public room_editor(Game_output out) {
        super(out);
    }

    public room_editor() {
    }

    @Override
    public void iObjs() {
        this.game_w = this.getGameW();
        this.game_h = this.getGameH();
        int w = this.getW();
        int h = this.getH();
        gui_list obj_selector = new gui_list(0.0, 0.0, w - this.game_w, h);
        this.obj_create((Obj)obj_selector);
        gui_window create_options = new gui_window(w - this.game_w, this.game_h, this.game_w, h - this.game_h);
        this.populate_option_buttons(create_options);
        this.obj_create((Obj)create_options);
        int border_size = 2;
        this.level = this.createEditor(w - this.game_w - 2 * border_size, 0.0, this.game_w + 2 * border_size, this.game_h + 2 * border_size);
        this.obj_create((Obj)this.level);
        EntitySelector selector_spec = this.getEntitySelector();
        selector_spec.populate_potential_objects(obj_selector);
    }

    public abstract gui_level_editor createEditor(double var1, double var3, int var5, int var6);

    public abstract EntitySelector getEntitySelector();

    public abstract int getGameW();

    public abstract int getGameH();

    protected abstract String getFileRootFolderName();

    protected abstract String getLevelFileTypeName();

    protected abstract room_GameTree getGameTreeRoom(File var1, File var2);

    protected abstract String getSavedFileLocation();

    protected abstract Room getMainRoom();

    public void populate_option_buttons(gui_window W) {
        this.grid_toggle = new gui_button(0.0, 0.0, 128, 64);
        this.grid_toggle.setText("Grid");
        W.obj_create((Obj)this.grid_toggle);
        this.lights_toggle = new gui_button(128.0, 0.0, 128, 64);
        this.lights_toggle.setText("Lights");
        W.obj_create((Obj)this.lights_toggle);
        this.save_level = new gui_button(128.0, 64.0, 128, 64);
        this.save_level.setText("Save");
        W.obj_create((Obj)this.save_level);
        this.load_level = new gui_button(0.0, 64.0, 128, 64);
        this.load_level.setText("Open");
        W.obj_create((Obj)this.load_level);
        this.run_level = new gui_button(0.0, 128.0, 256, 64);
        this.run_level.setText("Run Level");
        this.run_level.setRestingColor(Colors.C_YELLOW);
        W.obj_create((Obj)this.run_level);
        chooser_room = new room_fileChooser(this.getLevelFileTypeName(), this.getFileRootFolderName());
        this.clearRoom = new gui_button(0.0, 192.0, 128, 64);
        this.clearRoom.setText("Clear");
        this.clearRoom.setRestingColor(Colors.C_ERROR);
        W.obj_create((Obj)this.clearRoom);
        this.label_mouse_x = new gui_label(256.0, 64.0, 128, 64);
        this.label_mouse_y = new gui_label(384.0, 64.0, 128, 64);
        W.obj_create((Obj)this.label_mouse_x);
        W.obj_create((Obj)this.label_mouse_y);
        this.createDirectionButtons(W);
        obj_button temp = new obj_button(384.0, 0.0, 128, 64);
        temp.setText("Deselect");
        W.obj_create((Obj)temp);
        this.edit_mode = new gui_booleanInput(256.0, 0.0, 128, 64);
        this.edit_mode.setText("Edit");
        this.edit_mode.setColors(Colors.C_GREEN, Colors.C_RED);
        W.obj_create((Obj)this.edit_mode);
        File level_file = new File(this.getFileRootFolderName());
        File saved_file = new File(this.getSavedFileLocation());
        this.room_level_tree = this.getGameTreeRoom(level_file, saved_file);
        this.button_level_tree = new gui_button(128.0, 192.0, 128, 64);
        this.button_level_tree.setText("Graph");
        W.obj_create((Obj)this.button_level_tree);
        this.button_run_game = new gui_button(256.0, 192.0, 128, 64);
        this.button_run_game.setText("Run Game");
        W.obj_create((Obj)this.button_run_game);
    }

    private void createDirectionButtons(gui_window W) {
        directions = new gui_array<gui_booleanInput>(512.0, 0.0, 64, 64, 4, 4, new foo());
        W.obj_create((Obj)directions);
        gui_booleanInput b = directions.getElem(0, 0);
        b.setText("All");
        BufferedImage[] arrows = ArrowImageFactory.getArrows(64);
        int i = 1;
        while (i < 4) {
            b = directions.getElem(i, 0);
            b.setImage(arrows[0]);
            ++i;
        }
        i = 1;
        while (i < 4) {
            b = directions.getElem(0, i);
            b.setImage(arrows[6]);
            ++i;
        }
        b = directions.getElem(1, 1);
        b.setImage(arrows[3]);
        b = directions.getElem(1, 2);
        b.setImage(arrows[2]);
        b = directions.getElem(1, 3);
        b.setImage(arrows[1]);
        b = directions.getElem(2, 3);
        b.setImage(arrows[0]);
        b = directions.getElem(3, 3);
        b.setImage(arrows[7]);
        b = directions.getElem(3, 2);
        b.setImage(arrows[6]);
        b = directions.getElem(3, 1);
        b.setImage(arrows[5]);
        b = directions.getElem(2, 1);
        b.setImage(arrows[4]);
    }

    @Override
    public void update() {
        super.update();
        this.label_mouse_x.setText("X: " + (Game_input.mouse_x - (int)this.level.getX()) / 16 * 16);
        this.label_mouse_y.setText("Y: " + (Game_input.mouse_y - (int)this.level.getY()) / 16 * 16);
        if (this.grid_toggle.flag()) {
            this.level.toggleGrid();
        }
        if (this.clearRoom.flag()) {
            this.level.killEntities();
        }
        if (this.calling && ((Boolean)chooser_room.getReturnData()).booleanValue()) {
            this.calling = false;
            File file = chooser_room.getFile();
            switch (this.fileMode) {
                case save: {
                    this.saveLevel(file);
                    break;
                }
                case load: {
                    this.openLevel(file);
                    break;
                }
                case run: {
                    this.saveLevel(file);
                    room_level level = this.getRoomLevel(file);
                    this.room_goto(level);
                    level.enterFullAnimationMode();
                }
            }
            return;
        }
        if (this.save_level.flag()) {
            this.fileMode = FileMode.save;
            chooser_room.call(this);
            chooser_room.getChooser().refresh();
            chooser_room.saveMode();
            this.calling = true;
            return;
        }
        if (this.load_level.flag()) {
            this.fileMode = FileMode.load;
            chooser_room.call(this);
            chooser_room.getChooser().refresh();
            chooser_room.openMode();
            this.calling = true;
            return;
        }
        if (this.run_level.flag()) {
            this.fileMode = FileMode.run;
            chooser_room.call(this);
            chooser_room.getChooser().refresh();
            chooser_room.saveMode();
            this.calling = true;
            return;
        }
        if (this.button_level_tree.flag()) {
            this.room_level_tree.call(this);
        }
        int i = 1;
        while (i < 4) {
            this.synchRow(i);
            this.synchCol(i);
            ++i;
        }
        this.synchAll();
        if (this.edit_mode.input_changed()) {
            this.level.setEditMode(this.edit_mode.query());
        }
        if (this.button_run_game.flag()) {
            this.room_goto(this.getMainRoom());
            return;
        }
    }

    @Override
    public void keyR(int key) {
        super.keyR(key);
        if (key == 32) {
            this.edit_mode.toggle();
        }
    }

    private void synchRow(int r) {
        gui_booleanInput b = directions.getElem(r, 0);
        if (b.input_changed()) {
            int c = 1;
            while (c < 4) {
                directions.getElem(r, c).toggle();
                ++c;
            }
        }
    }

    private void synchCol(int c) {
        gui_booleanInput b = directions.getElem(0, c);
        if (b.input_changed()) {
            int r = 1;
            while (r < 4) {
                directions.getElem(r, c).toggle();
                ++r;
            }
        }
    }

    private void synchAll() {
        gui_booleanInput b = directions.getElem(0, 0);
        if (b.input_changed()) {
            int r = 1;
            while (r < 4) {
                int c = 1;
                while (c < 4) {
                    directions.getElem(r, c).toggle();
                    ++c;
                }
                ++r;
            }
        }
    }

    protected abstract room_level getRoomLevel(File var1);

    protected abstract String getVersion();

    @rootSerial
    public void saveLevel(File file) {
        FileIO.createFile(file);
        PrintStream stream = FileIO.getStream(file);
        stream.println(this.level.getSerialName());
        stream.println(this.getVersion());
        stream.println();
        this.level.serializeTo(stream);
        FileIO.closeFile(file);
    }

    public void openLevel(File file) {
        this.level.serializeFrom(file);
        this.setFile(file);
    }

    private void setFile(File file) {
        chooser_room.setFile(file);
    }

    public static BitSet getDirectionAttribute() {
        BitSet output = new BitSet();
        int i = 0;
        while (i < 8) {
            int c;
            int r;
            switch (i) {
                default: {
                    r = 2;
                    c = 3;
                    break;
                }
                case 1: {
                    r = 1;
                    c = 3;
                    break;
                }
                case 2: {
                    r = 1;
                    c = 2;
                    break;
                }
                case 3: {
                    r = 1;
                    c = 1;
                    break;
                }
                case 4: {
                    r = 2;
                    c = 1;
                    break;
                }
                case 5: {
                    r = 3;
                    c = 1;
                    break;
                }
                case 6: {
                    r = 3;
                    c = 2;
                    break;
                }
                case 7: {
                    r = 3;
                    c = 3;
                }
            }
            if (directions.getElem(r, c).query()) {
                output.setBit(i, true);
            }
            ++i;
        }
        return output;
    }

    private static enum FileMode {
        save,
        load,
        run;

    }

    private class foo
    implements Function<Boolean, gui_booleanInput> {
        Color c1 = Colors.Color_hsv(126.0, 100.0, 100.0);
        Color c2 = Colors.Color_hsv(0.0, 100.0, 100.0);

        private foo() {
        }

        @Override
        public gui_booleanInput eval(Boolean input) {
            gui_booleanInput box = new gui_booleanInput(0.0, 0.0, 1, 1);
            box.setColors(this.c1, this.c2);
            return box;
        }
    }
}

